// $Id: CDialog.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDialog.hpp"
using Exponent::GUI::Basics::CDialog;

#ifdef WIN32
const unsigned long CDialog::CDIALOG_OK_OPTION			= MB_OK;						
const unsigned long CDialog::CDIALOG_ASTERISK_OPTION	= MB_ICONASTERISK;
const unsigned long CDialog::CDIALOG_EXCLAMATION_OPTION	= MB_ICONEXCLAMATION;
const unsigned long CDialog::CDIALOG_HAND_OPTION		= MB_ICONHAND;
const unsigned long CDialog::CDIALOG_QUESTION_OPTION	= MB_ICONQUESTION;
const unsigned long CDialog::CDIALOG_SIMPLE_OPTION		= MB_OK;
const unsigned long CDialog::CDIALOG_MAX_FILTER_STRING	= 512;
#else
const unsigned long CDialog::CDIALOG_OK_OPTION			= kAlertPlainAlert;								
const unsigned long CDialog::CDIALOG_ASTERISK_OPTION	= kAlertCautionAlert;							
const unsigned long CDialog::CDIALOG_EXCLAMATION_OPTION	= kAlertCautionAlert;				
const unsigned long CDialog::CDIALOG_HAND_OPTION		= kAlertStopAlert;					
const unsigned long CDialog::CDIALOG_QUESTION_OPTION	= kAlertNoteAlert;
const unsigned long CDialog::CDIALOG_SIMPLE_OPTION		= kAlertPlainAlert;
const unsigned long CDialog::CDIALOG_MAX_FILTER_STRING	= 512;

//	===========================================================================

#include <Basics/CPascalString.hpp>
using Exponent::Basics::CPascalString;

//	===========================================================================

#endif

//	===========================================================================
void CDialog::notifyUser(const CString &message, const CString &title, const bool isSerious)
{
#ifdef WIN32
	if (isSerious)
	{
		MessageBox(NULL, message.getString(), title.getString(), MB_OK | MB_ICONSTOP);
	}
	else
	{
		MessageBox(NULL, message.getString(), title.getString(), MB_OK);
	}
#else
	CString myTitle   = title;
	CString myMessage = message;
	
	CFStringRef theTitle   = myTitle.getStringAsCFStringRef();
	CFStringRef theMessage = myMessage.getStringAsCFStringRef();

	CFOptionFlags flags = (isSerious) ? kCFUserNotificationStopAlertLevel : kCFUserNotificationPlainAlertLevel;
	CFOptionFlags retFlag = 0;
    CFUserNotificationDisplayAlert(0, flags, NULL, NULL, NULL, theTitle, theMessage, NULL, NULL, NULL, &retFlag);

	CFRelease(theTitle);
	CFRelease(theMessage);
#endif
}

//	===========================================================================
bool CDialog::promptUser(const CString &message, const CString &title)
{
#ifdef WIN32
	return (MessageBox(NULL, message.getString(), title.getString(), MB_YESNO | MB_ICONQUESTION) == IDYES);
#else
	CString myTitle			= title;
	CString myMessage		= message;
	CString normalButton    = "Yes";
	CString alternateButton = "No";
	
	CFStringRef theTitle     = myTitle.getStringAsCFStringRef();
	CFStringRef theMessage   = myMessage.getStringAsCFStringRef();
	CFStringRef theNormal    = normalButton.getStringAsCFStringRef();
	CFStringRef theAlternate = alternateButton.getStringAsCFStringRef();
	
	CFOptionFlags flags = 0;
	bool returnValue    = false;
	if (CFUserNotificationDisplayAlert (0, kCFUserNotificationPlainAlertLevel, NULL, NULL, NULL, theTitle, theMessage, theNormal, theAlternate, NULL, &flags) == 0)
	{
		returnValue = ((flags & 0x3) == 0);
	}
	
	CFRelease(theTitle);
	CFRelease(theMessage);
	CFRelease(theNormal);
	CFRelease(theAlternate);
	
	return returnValue;
#endif
}

//	===========================================================================
void CDialog::audioPrompt()
{
#ifdef WIN32
	MessageBeep(MB_OK);
#else
	SysBeep(50);
#endif
}

//	===========================================================================
bool CDialog::openSaveDialog(const CSystemString &path, CSystemString &filename, const CString &title, const CString &filterDescription,  const CString &filterExtension)
{
#ifdef WIN32
	OPENFILENAME openFileName;
	memset(&openFileName, 0, sizeof(OPENFILENAME));

	// Create the filter string (this appends *.* variant)
	char filterString[CDIALOG_MAX_FILTER_STRING];
	createDialogFilter(filterString, filterDescription, filterExtension);

	// Construct the filename
	char fname[CDIALOG_MAX_FILTER_STRING];
	memset(fname, 0, CDIALOG_MAX_FILTER_STRING * sizeof(char));
	if (!(filename == CString::CSTRING_EMPTY_STRING ||
		  filename == CString::CSTRING_NULL_STRING))
	{
		CString myFilename = filename;
		myFilename.appendString(".");
		myFilename.appendString(filterExtension);
		myFilename.getString(fname, CDIALOG_MAX_FILTER_STRING);
	}

	// Setup the file structure
	openFileName.lStructSize	 = sizeof(OPENFILENAME);
	openFileName.hwndOwner		 = NULL;
	openFileName.hInstance		 = NULL;
	openFileName.lpstrTitle		 = title.getString();
	openFileName.Flags			 = OFN_LONGNAMES | OFN_ENABLESIZING | OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST; //OFN_ALLOWMULTISELECT
	openFileName.lpstrInitialDir = path.getString();
	openFileName.lpstrFilter	 = filterString;
	openFileName.nFilterIndex	 = 0;
	openFileName.lpstrFile		 = fname;
	openFileName.nMaxFile		 = CDIALOG_MAX_FILTER_STRING;
	
	if (GetSaveFileName(&openFileName))
	{
		filename = fname; 
		return true;
	}
	return false;
#else
	bool complete = false;
	NavDialogRef dialogReference = NULL;
    NavReplyRecord replyRecord;
	NavDialogCreationOptions creationOptions;
	
	// Store the message and the title
	CString cMessage = filterDescription;
	CString cTitle   = title;
	
	// Now we convert them to apple CStringRefs
	CFStringRef message		= cMessage.getStringAsCFStringRef();
	CFStringRef windowTitle = cTitle.getStringAsCFStringRef();

	// Setup the default filename for the object
	CString cName    = filename;
	cName.appendString(".");
	cName.appendString(filterExtension);
	CFStringRef name = cName.getStringAsCFStringRef();
	
	// Setup our creation options
	NavGetDefaultDialogCreationOptions(&creationOptions);
	creationOptions.version      = kNavDialogCreationOptionsVersion;
	creationOptions.optionFlags |= kNavPreserveSaveFileExtension;
	creationOptions.message		 = message;
    creationOptions.modality     = kWindowModalityAppModal;
	creationOptions.parentWindow = NULL;
	creationOptions.windowTitle  = windowTitle;
	creationOptions.saveFileName = name;
	
	NavCreatePutFileDialog(&creationOptions, 0, 0, NULL, NULL, &dialogReference);
	setDefaultDialogLocation(dialogReference, path);

    if (NavDialogRun(dialogReference) == noErr)
	{
		if (NavDialogGetReply(dialogReference, &replyRecord) == noErr)
		{
			if (replyRecord.validRecord)
			{
				AEKeyword theKeyword;
				DescType theType;
				FSRef theFileReference;
				Size theFileSize;
				
				if (AEGetNthPtr(&replyRecord.selection, 1, typeFSRef, &theKeyword, &theType, &theFileReference, sizeof(FSRef), &theFileSize) == noErr)
				{
					// Buffer to hold the file path
					char buffer[_MAX_PATH];
					memset(buffer, 0, _MAX_PATH * sizeof(char));
					
					if (FSRefMakePath(&theFileReference, (UInt8 *)buffer, _MAX_PATH) == noErr)
					{
						// Get the name of the document
						CFStringRef theNameTheyEntered = NavDialogGetSaveFileName(dialogReference);
						CSystemString theString;
						
						theString.setStringFromCFStringRef(theNameTheyEntered);
						CFRelease(theNameTheyEntered);
						
						filename = buffer;
						filename.appendPath(theString);
						complete = true;
					}
				}
			}
		}
	}
	
	if (dialogReference) NavDialogDispose(dialogReference);
	NavDisposeReply(&replyRecord);
	CFRelease(message);
	CFRelease(windowTitle);
	CFRelease(name);
	
	return complete;
#endif
}

//	===========================================================================
bool CDialog::openFileDialog(const CSystemString &path, CSystemString &filename, const CString &title, const CString &filterDescription, const CString &filterExtension)
{
#ifdef WIN32
	OPENFILENAME openFileName;
	memset(&openFileName, 0, sizeof(OPENFILENAME));

	char filterString[CDIALOG_MAX_FILTER_STRING];
	createDialogFilter(filterString, filterDescription, filterExtension);

	char fname[CDIALOG_MAX_FILTER_STRING];
	memset(fname, 0, CDIALOG_MAX_FILTER_STRING * sizeof(char));
	if (!(filename == CString::CSTRING_EMPTY_STRING ||
		  filename == CString::CSTRING_NULL_STRING))
	{
		CString myFilename = filename;
		myFilename.appendString(".");
		myFilename.appendString(filterExtension);
		myFilename.getString(fname, CDIALOG_MAX_FILTER_STRING);
	}

	openFileName.lStructSize	 = sizeof(OPENFILENAME);
	openFileName.hwndOwner		 = NULL;
	openFileName.hInstance		 = NULL;
	openFileName.lpstrTitle		 = title.getString();
	openFileName.Flags			 = OFN_LONGNAMES | OFN_ENABLESIZING | OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST; //OFN_ALLOWMULTISELECT
	openFileName.lpstrInitialDir = path.getString();
	openFileName.lpstrFilter	 = filterString;
	openFileName.nFilterIndex	 = 0;
	openFileName.lpstrFile		 = fname;
	openFileName.nMaxFile		 = CDIALOG_MAX_FILTER_STRING;
	
	if (GetOpenFileName(&openFileName))
	{
		filename = fname; 
		return true;
	}
	return false;
#else
	bool complete = false;
	NavDialogRef dialogReference = NULL;
    NavReplyRecord replyRecord;
	NavDialogCreationOptions creationOptions;
	NavTypeListHandle typeList = 0;
	
	CString cMessage = filterDescription;
	CString cTitle   = title;
	
	CFStringRef message		= cMessage.getStringAsCFStringRef();
	CFStringRef windowTitle = cTitle.getStringAsCFStringRef();
	
	NavGetDefaultDialogCreationOptions(&creationOptions);
	creationOptions.version     = kNavDialogCreationOptionsVersion;
	creationOptions.optionFlags = kNavDefaultNavDlogOptions; 
	creationOptions.message		= message;
    creationOptions.modality    = kWindowModalityAppModal;
	creationOptions.windowTitle = windowTitle;

	// Store the extension that we are going to create
	CString extensionToFind = filterExtension;
	
	// Create the chooser dialog
	NavCreateChooseFileDialog(&creationOptions, typeList, NULL, NULL, NewNavObjectFilterUPP(fileDialogProc), (void *)extensionToFind.getString(), &dialogReference);

	// Now we want to set the default location for the dialog box!
	setDefaultDialogLocation(dialogReference, path);

	// Now run the dialog box
    if (NavDialogRun(dialogReference) == noErr)
	{
		if (NavDialogGetReply(dialogReference, &replyRecord) == noErr)
		{
			if (replyRecord.validRecord)
			{
				AEKeyword theKeyword;
				DescType theType;
				FSRef theFileReference;
				Size theFileSize;
				
				if (AEGetNthPtr(&replyRecord.selection, 1, typeFSRef, &theKeyword, &theType, &theFileReference, sizeof(FSRef), &theFileSize) == noErr)
				{
					char buffer[_MAX_PATH];
					memset(buffer, 0, _MAX_PATH * sizeof(char));
					
					if (FSRefMakePath(&theFileReference, (UInt8 *)buffer, _MAX_PATH) == noErr)
					{
						filename = buffer;
						complete = true;
					}
				}
			}
		}
	}
	
	if (dialogReference) NavDialogDispose(dialogReference);
	NavDisposeReply(&replyRecord);
	CFRelease(message);
	CFRelease(windowTitle);
	
	return complete;
#endif
}

//	===========================================================================
bool CDialog::openFolderDialog(CSystemString &filename, const CString &title)
{
#ifdef WIN32
	// The path that we are reading in to
	char path[_MAX_PATH];
	memset(path, 0, _MAX_PATH * sizeof(char));

	// Setup the browse info
    BROWSEINFO browseInfo = { 0 };
	browseInfo.ulFlags    = BIF_EDITBOX | BIF_NEWDIALOGSTYLE;
	browseInfo.lpszTitle  = title.getString();

	// Now browse for the folder
    LPITEMIDLIST pidl = SHBrowseForFolder(&browseInfo);

	// If we got something valid back
    if (pidl != 0)
    {
		bool retval = false;
        // get the name of the folder and put it in path
        if (SHGetPathFromIDList(pidl, path))
		{
			filename = path;
			retval = true;
		}

		// Now release the stuff that we have created
		IMalloc *imalloc = NULL;
		if (SUCCEEDED(SHGetMalloc(&imalloc)))
		{
			imalloc->Free(pidl);
			imalloc->Release();
		}

		return retval;
    }
	return false;
#else
	bool complete = false;
	NavDialogRef dialogReference;
    NavReplyRecord replyRecord;
	NavDialogCreationOptions creationOptions;

	CString cTitle          = title;
	CFStringRef windowTitle = cTitle.getStringAsCFStringRef();
	
	NavGetDefaultDialogCreationOptions(&creationOptions);
	creationOptions.version     = kNavDialogCreationOptionsVersion;
	creationOptions.optionFlags = kNavDefaultNavDlogOptions; 
    creationOptions.modality    = kWindowModalityAppModal;
	creationOptions.windowTitle = windowTitle;

	NavCreateChooseFolderDialog(&creationOptions, NULL, NewNavObjectFilterUPP(folderDialogProc), NULL, &dialogReference);
	setDefaultDialogLocation(dialogReference, "/");
	
    if (NavDialogRun(dialogReference) == noErr)
	{
		if (NavDialogGetReply(dialogReference, &replyRecord) == noErr)
		{
			if (replyRecord.validRecord)
			{
				AEKeyword theKeyword;
				DescType theType;
				FSRef theFileReference;
				Size theFileSize;
				
				if (AEGetNthPtr(&replyRecord.selection, 1, typeFSRef, &theKeyword, &theType, &theFileReference, sizeof(FSRef), &theFileSize) == noErr)
				{
					char buffer[_MAX_PATH];
					memset(buffer, 0, _MAX_PATH * sizeof(char));
					
					if (FSRefMakePath(&theFileReference, (UInt8 *)buffer, _MAX_PATH) == noErr)
					{
						filename = buffer;
						complete = true;
					}
				}
			}
		}
	}
	
	NavDialogDispose(dialogReference);
	NavDisposeReply(&replyRecord);
	CFRelease(windowTitle);
	
	return complete;
#endif
}

#ifdef WIN32
//	===========================================================================
void CDialog::createDialogFilter(char *filterString, const CSystemString &filterDescription, const CSystemString &filterExtension)
{
	memset(filterString, 0, CDIALOG_MAX_FILTER_STRING * sizeof(char));
	
	long position = 0;

	memcpy(filterString, filterDescription.getString(), filterDescription.getNumberOfCharacters() * sizeof(char) + 1);
	position += filterDescription.getNumberOfCharacters();

	CString myExtension = "*.";
	myExtension.appendString(filterExtension);
	memcpy(filterString + position, myExtension.getString(), myExtension.getNumberOfCharacters() * sizeof(char) + 1);
	position += myExtension.getNumberOfCharacters();

	memcpy(filterString + position, "All files (*.*)", strlen("All Files (*.*)") + 1);
	position += (long)strlen("All files (*.*)") + 1;
	
	memcpy(filterString + position, "*.*", strlen("*.*") + 1);
	position += (long)(strlen("*.*") + 1);

	memset(filterString + position, 0, (CDIALOG_MAX_FILTER_STRING - position) * sizeof(char));
}

#else
//	===========================================================================
pascal Boolean CDialog::fileDialogProc(AEDesc *theItem, void *info, void *userData, NavFilterModes filterMode)
{
	bool display = false;
	NavFileOrFolderInfo *theInfo = (NavFileOrFolderInfo*)info;
	
	if (theInfo == NULL)
	{
		return display;
	}
	
	// If we dont have an FSS convert it
	if (theItem->descriptorType != typeFSS)
	{
		AEDesc copyItem;
		AECoerceDesc(theItem, typeFSS, &copyItem);
		
		if (theInfo->isFolder)
		{
			display = true;
		}
		else
		{
			FSSpec theFileSpecification;
			if (AEGetDescData(&copyItem, (void *)&theFileSpecification, sizeof(FSSpec)) == noErr)
			{
				// Get the file name from the file spec
				char filename[255];
				memset(filename, 0, sizeof(char) * 255);
				memcpy(filename, theFileSpecification.name + 1, ((unsigned char*)theFileSpecification.name)[0]);	
				
				CSystemString string;
				string.setString(filename);
				if (string.hasExtension((char *)userData))
				{
					display = true;
				}
			}
		}
		AEDisposeDesc(&copyItem);
	}
	else
	{
		if (theInfo->isFolder)
		{
			display = true;
		}
		else
		{
			FSSpec theFileSpecification;
			if (AEGetDescData(theItem, (void *)&theFileSpecification, sizeof(FSSpec)) == noErr)
			{
				// Get the file name from the file spec
				char filename[255];
				memset(filename, 0, sizeof(char) * 255);
				memcpy(filename, theFileSpecification.name + 1, ((unsigned char*)theFileSpecification.name)[0]);	
				
				CSystemString string;
				string.setString(filename);
				if (string.hasExtension((char *)userData))
				{
					display = true;
				}
			}
		}
	}
   return display;
}

//	===========================================================================
pascal Boolean CDialog::folderDialogProc(AEDesc *theItem, void *info, NavCallBackUserData callBackUD, NavFilterModes filterMode)
{
	NavFileOrFolderInfo *theInfo = (NavFileOrFolderInfo*)info;
	
	if (theInfo == NULL || !theInfo->isFolder)
	{
		return false;
	}
	return true;
}

//	===========================================================================
void CDialog::setDefaultDialogLocation(NavDialogRef dialogReference, const CSystemString &path)
{
	// Turn the path in to an URL
	CSystemString myPath = path;
	CFStringRef filename = myPath.getStringAsCFStringRef();
	CFURLRef url		 = CFURLCreateWithFileSystemPath(kCFAllocatorDefault, filename, kCFURLPOSIXPathStyle, false);
	CFRelease(filename);
	
	// Now convert over to FSpec / FSRef / AEDesc
	FSRef fsRef;
	FSSpec fsSpec;
	AEDesc theLocation   = { 'null', NULL };
	
	if (url == NULL)
	{
	
	}
	else if (!CFURLGetFSRef(url, &fsRef))
	{
	
	}
	else
	{
		filename = CFURLGetString(url);
		OSStatus errorStatus = FSGetCatalogInfo(&fsRef, kFSCatInfoNone, NULL, NULL, &fsSpec, NULL);
		errorStatus			 = AECreateDesc(typeFSS, &fsSpec, sizeof(FSSpec), &theLocation);
		errorStatus			 = NavCustomControl(dialogReference, kNavCtlSetLocation, (void *)&theLocation);
	}
}
#endif
